#include <iostream>
#include <algorithm>

using namespace std;


int bins_left(int* a, int l, int r, int x)
{
    if(x < a[l])
        return l-1;

    if(l == r)
        return l;

    int mid = (l+r)/2;

    if(x < a[mid])
        return bins_left(a, l, mid - 1, x);

    if(x > a[mid])
        return bins_left(a, mid + 1, r, x);

    if(x == a[mid])
    {
        if(mid == l)
            return mid;
        if(a[mid-1] != a[mid])
            return mid;
        if(a[mid-1] == a[mid])
            return bins_left(a, l, mid - 1, x);
    }
}

int bins_right(int* a, int l, int r, int x)
{
    if(x < a[l])
        return l-1;

    if(l == r)
        return l;

    int mid = (l+r)/2;

    if(x < a[mid])
        return bins_right(a, l, mid - 1, x);

    if(x > a[mid])
        return bins_right(a, mid + 1, r, x);

    if(x == a[mid])
    {
        if(mid == r)
            return mid;
        if(a[mid+1] != a[mid])
            return mid;
        if(a[mid+1] == a[mid])
            return bins_right(a, mid+1, r, x);
    }
}

int main()
{
    int n, q;
    int a[200010];

    scanf("%d%d", &n, &q);

    for(int i = 0; i < n; i++)
        scanf("%d", &a[i]);

    sort(a, a+n);

    int m = n/2;
    for(int i = 0; i < q; i++)
    {
        int b;
        scanf("%d", &b);
        //printf("%d %d\n", bins_left(a, 0, n-1, b), bins_right(a, 0, n-1, b));
        //printf("%d\n", bins_right(a, 0, n-1, b));
        int l = bins_left(a, 0, n-1, b);
        int r = bins_right(a, 0, n-1, b);

        if(a[l] == b)
        {
            if(l <= m && m <= r)
                printf("0\n");
            if(l > m)
                printf("%d\n", 2*abs(m - l) - (l != m)*((l>m) == n%2));
            if(r < m)
                printf("%d\n", 2*abs(m - r) - (r != m)*((r>m) == n%2));
        }
        if(a[l] != b)
        {
            if(l < m)
                printf("%d\n", 2*abs(m - l) - (l != m)*((l>m) == n%2));
            if(l >= m)
                printf("%d\n", 2*abs(m - l - 1) - (l + 1 != m)*((l + 1>m) == n%2));
        }

    }

    return 0;
}
/*
2*abs(n/2 - i) - (i != n/2)*((i>n/2) == n%2)
 izraz za clanove niza

10 9
1 3 5 5 5 5 5 7 7 7
0 1 2 3 4 5 6 7 8

5 3
1 3 5 7 9
5 7 10
*/